/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.i2b2.eclipse.plugins.workplace.util;

import edu.harvard.i2b2.eclipse.plugins.workplace.util.MessageUtil;
import edu.harvard.i2b2.wkplclient.datavo.wdo.XmlValueType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlUtil {
    private static XmlUtil thisInstance;
    private static Log log;

    static {
        log = LogFactory.getLog((String)XmlUtil.class.getName());
        thisInstance = new XmlUtil();
    }

    public static XmlUtil getInstance() {
        return thisInstance;
    }

    public static XmlValueType stringToXml(String c_xml) {
        if (c_xml == null) {
            return null;
        }
        SAXBuilder parser = new SAXBuilder();
        StringReader xmlStringReader = new StringReader(c_xml);
        Element rootElement = null;
        try {
            Document metadataDoc = parser.build((Reader)xmlStringReader);
            DOMOutputter out = new DOMOutputter();
            org.w3c.dom.Document doc = out.output(metadataDoc);
            rootElement = doc.getDocumentElement();
        }
        catch (JDOMException e) {
            log.error((Object)e.getMessage());
            return null;
        }
        catch (IOException e1) {
            log.error((Object)e1.getMessage());
            return null;
        }
        if (rootElement != null) {
            XmlValueType xml = new XmlValueType();
            xml.getAny().add(rootElement);
            return xml;
        }
        return null;
    }

    public static String getName(XmlValueType xml) {
        NodeList resultElements;
        String name = null;
        Element rootElement = xml.getAny().get(0);
        NodeList nameElements = rootElement.getElementsByTagName("name");
        if (nameElements.getLength() == 0) {
            nameElements = rootElement.getElementsByTagNameNS("*", "panel");
            if (nameElements.getLength() == 0) {
                nameElements = rootElement.getElementsByTagName("query_name");
                if (nameElements.getLength() == 0) {
                    return "PDO";
                }
                name = nameElements.item(0).getTextContent();
            } else {
                name = nameElements.item(0).getAttributes().getNamedItem("name").getNodeValue();
            }
            if (name != null) {
                return name;
            }
            return "ABC" + MessageUtil.getInstance().getTimestamp();
        }
        if (nameElements.item(0).getTextContent().equals("PATIENT_COUNT_XML")) {
            NodeList resultElements2 = rootElement.getElementsByTagName("result_instance_id");
            if (resultElements2.getLength() > 0) {
                String resultInstanceId = resultElements2.item(0).getTextContent();
                return String.valueOf(nameElements.item(0).getTextContent()) + "_" + resultInstanceId;
            }
        } else if (nameElements.item(0).getTextContent().equals("PATIENTSET") && (resultElements = rootElement.getElementsByTagName("description")).getLength() > 0) {
            return resultElements.item(0).getTextContent();
        }
        return nameElements.item(0).getTextContent();
    }

    public static String getPatientId(XmlValueType xml) {
        Element rootElement = xml.getAny().get(0);
        NodeList nameElements = rootElement.getElementsByTagName("patient_id");
        if (nameElements.getLength() != 0) {
            return nameElements.item(0).getTextContent();
        }
        return MessageUtil.getInstance().getTimestamp();
    }

    public static String getIndex(XmlValueType xml) {
        Element rootElement = xml.getAny().get(0);
        NodeList indexElements = rootElement.getElementsByTagName("index");
        if (indexElements.getLength() == 0) {
            return null;
        }
        return indexElements.item(0).getTextContent();
    }

    public static Boolean hasConceptTag(XmlValueType xml) {
        Element rootElement = xml.getAny().get(0);
        NodeList conceptElements = rootElement.getElementsByTagNameNS("*", "concepts");
        if (conceptElements.getLength() == 0) {
            return false;
        }
        return true;
    }

    public static Boolean hasFolderTag(XmlValueType xml) {
        Element rootElement = xml.getAny().get(0);
        NodeList folderElements = rootElement.getElementsByTagName("folder");
        if (folderElements.getLength() == 0) {
            return false;
        }
        return true;
    }

    public static Boolean hasPatientSetTag(XmlValueType xml) {
        Element rootElement = xml.getAny().get(0);
        NodeList psElements = rootElement.getElementsByTagName("name");
        if (psElements.getLength() == 0) {
            return false;
        }
        Boolean result = false;
        int i = 0;
        while (i < psElements.getLength()) {
            String resultTypeName = psElements.item(i).getTextContent();
            if (resultTypeName.equals("PATIENTSET")) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public static Boolean hasPatientCountTag(XmlValueType xml) {
        Element rootElement = xml.getAny().get(0);
        NodeList pcElements = rootElement.getElementsByTagName("name");
        if (pcElements.getLength() == 0) {
            return false;
        }
        Boolean result = false;
        int i = 0;
        while (i < pcElements.getLength()) {
            String resultTypeName = pcElements.item(i).getTextContent();
            if (resultTypeName.equals("PATIENT_COUNT_XML")) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public static Boolean hasPrevQueryTag(XmlValueType xml) {
        Element rootElement = xml.getAny().get(0);
        NodeList pqElements = rootElement.getElementsByTagNameNS("*", "query_master");
        if (pqElements.getLength() == 0) {
            return false;
        }
        return true;
    }

    public static Boolean hasGroupTemplateTag(XmlValueType xml) {
        Element rootElement = xml.getAny().get(0);
        NodeList gtElements = rootElement.getElementsByTagNameNS("*", "panel");
        if (gtElements.getLength() == 0) {
            return false;
        }
        return true;
    }

    public static Boolean hasQueryDefinitionTag(XmlValueType xml) {
        Element rootElement = xml.getAny().get(0);
        NodeList gtElements = rootElement.getElementsByTagNameNS("*", "query_definition");
        if (gtElements.getLength() == 0) {
            return false;
        }
        return true;
    }

    public static Boolean hasObservationTag(XmlValueType xml) {
        Element rootElement = xml.getAny().get(0);
        NodeList gtElements = rootElement.getElementsByTagNameNS("*", "observation_set");
        if (gtElements.getLength() == 0) {
            return false;
        }
        return true;
    }

    public static Boolean hasPatientDataTag(XmlValueType xml) {
        Element rootElement = xml.getAny().get(0);
        NodeList gtElements = rootElement.getElementsByTagNameNS("*", "patient_data");
        if (gtElements.getLength() == 0) {
            return false;
        }
        return true;
    }

    public static Boolean hasPatientTag(XmlValueType xml) {
        Element rootElement = xml.getAny().get(0);
        NodeList gtElements = rootElement.getElementsByTagNameNS("*", "patient_set");
        if (gtElements.getLength() == 0) {
            return false;
        }
        return true;
    }
}

