/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.i2b2.eclipse.plugins.workplace.views;

import edu.harvard.i2b2.common.util.jaxb.JAXBUnWrapHelper;
import edu.harvard.i2b2.common.util.jaxb.JAXBUtilException;
import edu.harvard.i2b2.eclipse.UserInfoBean;
import edu.harvard.i2b2.eclipse.plugins.workplace.util.MessageUtil;
import edu.harvard.i2b2.eclipse.plugins.workplace.util.WorkplaceJAXBUtil;
import edu.harvard.i2b2.eclipse.plugins.workplace.util.XmlUtil;
import edu.harvard.i2b2.eclipse.plugins.workplace.views.TreeData;
import edu.harvard.i2b2.eclipse.plugins.workplace.views.TreeNode;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.AddChildRequestMessage;
import edu.harvard.i2b2.wkplclient.datavo.dnd.DndType;
import edu.harvard.i2b2.wkplclient.datavo.dnd.ObjectFactory;
import edu.harvard.i2b2.wkplclient.datavo.vdo.ConceptType;
import edu.harvard.i2b2.wkplclient.datavo.vdo.ConceptsType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.FolderType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.FoldersType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.XmlValueType;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

final class NodeDropListener
implements DropTargetListener {
    private Log log = LogFactory.getLog((String)NodeDropListener.class.getName());
    private final TreeViewer viewer;

    NodeDropListener(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void dragEnter(DropTargetEvent event) {
        TextTransfer textTransfer = TextTransfer.getInstance();
        if (textTransfer.isSupportedType(event.currentDataType) && event.detail == 16) {
            event.detail = 1;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
        TreeNode currentTarget = (TreeNode)event.item.getData();
        if (currentTarget.getData().getVisualAttributes().startsWith("F")) {
            return;
        }
        if (currentTarget.getData().getVisualAttributes().startsWith("C")) {
            return;
        }
        event.detail = 0;
    }

    /*
     * Unable to fully structure code
     */
    public void drop(DropTargetEvent event) {
        text = (String)event.data;
        if (text != null) {
            xml = XmlUtil.stringToXml(text);
            currentTarget = (TreeNode)event.item.getData();
            workItem = null;
            dragShareId = null;
            moveFlag = false;
            if (event.display.getData() != null) {
                if (event.display.getData().equals("M|O*V+E")) {
                    event.display.setData(null);
                } else {
                    workItem = (FolderType)event.display.getData();
                    dragShareId = workItem.getShareId();
                }
            }
            if (!currentTarget.getData().getShareId().equals("Y") && workItem != null && !dragShareId.equals("Y")) {
                event.display.setData((Object)"M|O*V+E");
                moveFlag = true;
            }
            visualAttribute = "";
            workXmlI2B2Type = "";
            name = XmlUtil.getName(xml);
            if (XmlUtil.hasFolderTag(xml).booleanValue()) {
                jaxbUtil = WorkplaceJAXBUtil.getJAXBUtil();
                folders = null;
                folder = null;
                try {
                    jaxbElement = jaxbUtil.unMashallFromString(text);
                    dndType = (DndType)jaxbElement.getValue();
                    folders = (FoldersType)new JAXBUnWrapHelper().getObjectByClass(dndType.getAny(), FoldersType.class);
                    folder = folders.getFolder().get(0);
                }
                catch (JAXBUtilException e) {
                    this.log.error((Object)("Unwrap error: " + e.getMessage()), (Throwable)e);
                    return;
                }
                data = new TreeData(folder);
                data.setParentIndex(currentTarget.getData().getIndex());
                data.setTableCd(currentTarget.getData().getTableCd());
                data.setVisualAttributes("FA");
                data.setShareId(currentTarget.getData().getShareId());
                node = new TreeNode(data);
                currentTarget.addChild(node);
                if (moveFlag.booleanValue()) {
                    node.moveNode(this.viewer).start();
                } else {
                    copiedTo = new AddChildRequestMessage().generateMessageId();
                    node.getData().setIndex(copiedTo);
                    event.display.setData((Object)(String.valueOf(copiedTo) + "," + data.getShareId()));
                    if (node.getData().getVisualAttributes().equals("FA")) {
                        placeholder = new TreeNode("working...", "working...", "LAO");
                        node.addChild(placeholder);
                    } else if (node.getData().getVisualAttributes().equals("FH")) {
                        placeholder = new TreeNode("working...", "working...", "LHO");
                        node.addChild(placeholder);
                    }
                    node.addNode(this.viewer).start();
                }
                this.viewer.refresh();
                return;
            }
            if (XmlUtil.hasConceptTag(xml).booleanValue()) {
                visualAttribute = "ZA";
                workXmlI2B2Type = "CONCEPT";
                try {
                    jaxbUtil = WorkplaceJAXBUtil.getJAXBUtil();
                    concept = null;
                    jaxbElement = jaxbUtil.unMashallFromString(text);
                    dndType = (DndType)jaxbElement.getValue();
                    conceptsType = (ConceptsType)new JAXBUnWrapHelper().getObjectByClass(dndType.getAny(), ConceptsType.class);
                    concepts = conceptsType.getConcept();
                    if (concepts == null) ** GOTO lbl124
                    for (ConceptType concept : concepts) {
                        conceptXml = this.createWorkXml(concept);
                        if (concept.getVisualattributes().startsWith("FA")) {
                            visualAttribute = "ZAF";
                        }
                        this.createWorkplaceNode(workItem, currentTarget, conceptXml, XmlUtil.getName(conceptXml), workXmlI2B2Type, visualAttribute, moveFlag);
                    }
                }
                catch (JAXBUtilException e) {
                    this.log.error((Object)("Unwrap error: " + e.getMessage()), (Throwable)e);
                    return;
                }
            } else if (XmlUtil.hasPatientSetTag(xml).booleanValue()) {
                visualAttribute = "ZA";
                workXmlI2B2Type = "PATIENT_COLL";
                this.createWorkplaceNode(workItem, currentTarget, xml, name, workXmlI2B2Type, visualAttribute, moveFlag);
            } else if (XmlUtil.hasPatientCountTag(xml).booleanValue()) {
                visualAttribute = "ZA";
                workXmlI2B2Type = "PATIENT_COUNT_XML";
                this.createWorkplaceNode(workItem, currentTarget, xml, name, workXmlI2B2Type, visualAttribute, moveFlag);
            } else if (XmlUtil.hasPrevQueryTag(xml).booleanValue()) {
                visualAttribute = "ZA";
                workXmlI2B2Type = "PREV_QUERY";
                this.createWorkplaceNode(workItem, currentTarget, xml, name, workXmlI2B2Type, visualAttribute, moveFlag);
            } else if (XmlUtil.hasGroupTemplateTag(xml).booleanValue()) {
                visualAttribute = "ZA";
                workXmlI2B2Type = "GROUP_TEMPLATE";
                this.createWorkplaceNode(workItem, currentTarget, xml, name, workXmlI2B2Type, visualAttribute, moveFlag);
            } else if (XmlUtil.hasQueryDefinitionTag(xml).booleanValue()) {
                visualAttribute = "ZA";
                workXmlI2B2Type = "QUERY_DEFINITION";
                this.createWorkplaceNode(workItem, currentTarget, xml, name, workXmlI2B2Type, visualAttribute, moveFlag);
            } else if (XmlUtil.hasPatientDataTag(xml).booleanValue()) {
                visualAttribute = "ZA";
                workXmlI2B2Type = "PDO";
                name = "PDO" + MessageUtil.getInstance().getTimestamp();
                this.createWorkplaceNode(workItem, currentTarget, xml, name, workXmlI2B2Type, visualAttribute, moveFlag);
            } else if (XmlUtil.hasObservationTag(xml).booleanValue()) {
                visualAttribute = "ZA";
                workXmlI2B2Type = "OBSERVATION";
                if (name.equals("PDO")) {
                    name = "OBS" + MessageUtil.getInstance().getTimestamp();
                }
                this.createWorkplaceNode(workItem, currentTarget, xml, name, workXmlI2B2Type, visualAttribute, moveFlag);
            } else if (XmlUtil.hasPatientTag(xml).booleanValue()) {
                visualAttribute = "ZA";
                workXmlI2B2Type = "PATIENT";
                if (name.equals("PDO")) {
                    name = "PATIENT:" + XmlUtil.getPatientId(xml);
                }
                this.createWorkplaceNode(workItem, currentTarget, xml, name, workXmlI2B2Type, visualAttribute, moveFlag);
            }
lbl124:
            // 12 sources

            if (visualAttribute.equals("")) {
                mBox = new MessageBox(Display.getCurrent().getActiveShell(), 34);
                mBox.setText("Unsupported Work Item Message");
                mBox.setMessage("Work item being dropped is not supported.");
                this.log.info((Object)"Work item being dropped is not supported.");
                mBox.open();
                return;
            }
            this.viewer.refresh();
        } else {
            this.log.debug((Object)"No transfer happened -- data was null");
        }
    }

    private XmlValueType createWorkXml(ConceptType concept) {
        StringWriter strWriter = null;
        ConceptsType concepts = new ConceptsType();
        concepts.getConcept().add(concept);
        try {
            strWriter = new StringWriter();
            DndType dnd = new DndType();
            edu.harvard.i2b2.wkplclient.datavo.vdo.ObjectFactory vdoOf = new edu.harvard.i2b2.wkplclient.datavo.vdo.ObjectFactory();
            dnd.getAny().add(vdoOf.createConcepts(concepts));
            ObjectFactory of = new ObjectFactory();
            WorkplaceJAXBUtil.getJAXBUtil().marshaller(of.createPluginDragDrop(dnd), (Writer)strWriter);
        }
        catch (JAXBUtilException jAXBUtilException) {
            this.log.error((Object)"Error marshalling Ont drag text");
        }
        return XmlUtil.stringToXml(strWriter.toString());
    }

    private void createWorkplaceNode(FolderType workItem, TreeNode currentTarget, XmlValueType workXml, String name, String workXmlI2B2Type, String visualAttribute, Boolean moveFlag) {
        TreeData tdata = new TreeData();
        if (workItem != null) {
            tdata.setTooltip(workItem.getTooltip());
            tdata.setName(workItem.getName());
            if (moveFlag.booleanValue()) {
                tdata.setIndex(workItem.getIndex());
            } else {
                tdata.setIndex(new AddChildRequestMessage().generateMessageId());
            }
        } else {
            tdata.setTooltip(String.valueOf(workXmlI2B2Type) + ":" + name);
            tdata.setName(name);
            tdata.setIndex(new AddChildRequestMessage().generateMessageId());
        }
        tdata.setParentIndex(currentTarget.getData().getIndex());
        tdata.setVisualAttributes(visualAttribute);
        tdata.setWorkXml(workXml);
        tdata.setWorkXmlI2B2Type(workXmlI2B2Type);
        tdata.setUserId(UserInfoBean.getInstance().getUserName());
        tdata.setGroupId(currentTarget.getData().getGroupId());
        tdata.setShareId(currentTarget.getData().getShareId());
        tdata.setWorkXmlSchema(null);
        tdata.setEntryDate(null);
        tdata.setChangeDate(null);
        tdata.setStatusCd(null);
        tdata.setTableCd(currentTarget.getData().getTableCd());
        TreeNode child = new TreeNode(tdata);
        currentTarget.addChild(child);
        if (moveFlag.booleanValue()) {
            child.moveNode(this.viewer).start();
        } else {
            child.addNode(this.viewer).start();
        }
    }
}

