/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.i2b2.eclipse.plugins.workplace.views;

import edu.harvard.i2b2.common.exception.I2B2Exception;
import edu.harvard.i2b2.eclipse.plugins.workplace.views.TreeData;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.AddChildRequestMessage;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.AnnotateChildResponseMessage;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.DeleteChildResponseMessage;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.GetChildrenResponseMessage;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.MoveChildResponseMessage;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.RenameChildResponseMessage;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.WorkplaceResponseMessage;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.WorkplaceServiceDriver;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.StatusType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.AnnotateChildType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.ChildType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.DeleteChildType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.FolderType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.FoldersType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.GetChildrenType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.GetReturnType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.RenameChildType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.XmlValueType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TreeNode {
    private Log log = LogFactory.getLog((String)TreeNode.class.getName());
    private TreeData data;
    private List children = new ArrayList();
    private TreeNode parent;
    private int result;

    public TreeNode(String index, String name, String visualAttributes) {
        this.data = new TreeData(index, name, visualAttributes);
    }

    public TreeNode(TreeData data) {
        this.data = data;
    }

    public Object getParent() {
        return this.parent;
    }

    public TreeNode addChild(TreeNode child) {
        this.children.add(child);
        child.parent = this;
        return this;
    }

    public List getChildren() {
        return this.children;
    }

    public TreeData getData() {
        return this.data;
    }

    public String toString() {
        return this.data.getName();
    }

    public String getIconKey() {
        String key = null;
        if (this.data.getVisualAttributes().substring(0, 1).equals("F")) {
            if (this.data.getVisualAttributes().substring(1).equals("A") || this.data.getVisualAttributes().substring(1).equals("I") || this.data.getVisualAttributes().substring(1).equals("H")) {
                key = "closedFolder";
            } else if (this.data.getVisualAttributes().substring(1).equals("AO") || this.data.getVisualAttributes().substring(1).equals("IO") || this.data.getVisualAttributes().substring(1).equals("HO")) {
                key = "openFolder";
            }
        } else if (this.data.getVisualAttributes().substring(0, 1).equals("C")) {
            if (this.data.getVisualAttributes().substring(1).equals("A") || this.data.getVisualAttributes().substring(1).equals("I") || this.data.getVisualAttributes().substring(1).equals("H")) {
                key = "closedCase";
            } else if (this.data.getVisualAttributes().substring(1).equals("AO") || this.data.getVisualAttributes().substring(1).equals("IO") || this.data.getVisualAttributes().substring(1).equals("HO")) {
                key = "openCase";
            }
        } else if (this.data.getVisualAttributes().substring(0, 1).equals("L")) {
            key = "leaf";
        } else if (this.data.getVisualAttributes().substring(0, 1).equals("Z")) {
            key = this.data.getVisualAttributes().equals("ZAF") ? "conceptFA" : this.data.getWorkXmlI2B2Type().toLowerCase();
        } else if (this.data.getVisualAttributes().substring(0, 1).equals("M")) {
            key = "multi";
        } else if (this.data.getVisualAttributes().equals("C-ERROR")) {
            key = "error";
        }
        return key;
    }

    public Thread getXMLData(TreeViewer viewer) {
        final TreeNode theNode = this;
        final TreeViewer theViewer = viewer;
        final Display theDisplay = Display.getCurrent();
        return new Thread(){

            public void run() {
                try {
                    theNode.updateChildren(theDisplay, theViewer);
                }
                catch (Exception e) {
                    System.setProperty("statusMessage", e.getMessage());
                }
                theDisplay.syncExec(new Runnable(){

                    public void run() {
                        theViewer.refresh((Object)theNode);
                    }
                });
            }
        };
    }

    public void updateChildren(Display theDisplay, final TreeViewer theViewer) {
        try {
            GetChildrenType parentType = new GetChildrenType();
            parentType.setBlob(true);
            parentType.setParent("\\\\" + this.getData().getTableCd() + "\\" + this.getData().getIndex());
            GetChildrenResponseMessage msg = new GetChildrenResponseMessage();
            StatusType procStatus = null;
            while (procStatus == null || !procStatus.getType().equals("DONE")) {
                String response = WorkplaceServiceDriver.getChildren(parentType);
                procStatus = msg.processResult(response);
                if (procStatus.getValue().equals("MAX_EXCEEDED")) {
                    theDisplay.syncExec(new Runnable(){

                        public void run() {
                            MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 196);
                            mBox.setText("Please Note ...");
                            mBox.setMessage("The node has exceeded maximum number of children\nPopulating the node will be slow\nDo you want to continue?");
                            TreeNode.this.result = mBox.open();
                        }
                    });
                    if (this.result == 128) {
                        TreeNode node = (TreeNode)this.getChildren().get(0);
                        node.getData().setName("Over maximum number of child nodes");
                        procStatus.setType("DONE");
                        continue;
                    }
                    parentType.setMax(null);
                    response = WorkplaceServiceDriver.getChildren(parentType);
                    procStatus = msg.processResult(response);
                    continue;
                }
                if (!procStatus.getType().equals("ERROR")) continue;
                System.setProperty("errorMessage", procStatus.getValue());
                theDisplay.syncExec(new Runnable(){

                    public void run() {
                        MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                        mBox.setText("Please Note ...");
                        mBox.setMessage("Server reports: " + System.getProperty("errorMessage"));
                        mBox.open();
                    }
                });
                return;
            }
            FoldersType allFolders = msg.doReadFolders();
            if (allFolders != null) {
                List<FolderType> folders = allFolders.getFolder();
                this.getChildren().clear();
                this.getNodesFromXMLString(folders);
            }
        }
        catch (AxisFault e) {
            this.log.error((Object)e.getMessage());
            theDisplay.syncExec(new Runnable(){

                public void run() {
                    MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                    mBox.setText("Please Note ...");
                    mBox.setMessage("Unable to make a connection to the remote server\nThis is often a network error, please try again");
                    mBox.open();
                }
            });
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            theDisplay.syncExec(new Runnable(){

                public void run() {
                    MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                    mBox.setText("Please Note ...");
                    mBox.setMessage("Error message delivered from the remote server\nYou may wish to retry your last action");
                    mBox.open();
                }
            });
        }
    }

    private void getNodesFromXMLString(List folders) {
        if (folders != null) {
            Iterator it = folders.iterator();
            while (it.hasNext()) {
                TreeNode placeholder;
                TreeData child = new TreeData((FolderType)it.next());
                TreeNode childNode = new TreeNode(child);
                if (child.getVisualAttributes().equals("FA") || child.getVisualAttributes().equals("CA")) {
                    placeholder = new TreeNode("working...", "working...", "LAO");
                    childNode.addChild(placeholder);
                } else if (child.getVisualAttributes().equals("FH") || child.getVisualAttributes().equals("CH")) {
                    placeholder = new TreeNode("working...", "working...", "LHO");
                    childNode.addChild(placeholder);
                }
                this.addChild(childNode);
            }
        }
    }

    public void getHomeFolders(TreeViewer viewer) {
        TreeNode theRoot = this;
        TreeViewer theViewer = viewer;
        Display theDisplay = Display.getCurrent();
        try {
            theRoot.updateFolders(theDisplay, theViewer);
            theViewer.expandToLevel((Object)theRoot, 1);
            theViewer.refresh((Object)theRoot);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
    }

    public void updateFolders(Display theDisplay, TreeViewer theViewer) {
        try {
            GetReturnType request = new GetReturnType();
            request.setType("core");
            GetChildrenResponseMessage msg = new GetChildrenResponseMessage();
            StatusType procStatus = null;
            while (procStatus == null || !procStatus.getType().equals("DONE")) {
                String response = null;
                response = Boolean.parseBoolean(System.getProperty("WPManager")) ? WorkplaceServiceDriver.getHomeFoldersByProject(request) : WorkplaceServiceDriver.getHomeFoldersByUserId(request);
                procStatus = msg.processResult(response);
                if (procStatus.getType().equals("ERROR")) {
                    System.setProperty("errorMessage", procStatus.getValue());
                    return;
                }
                procStatus.setType("DONE");
            }
            FoldersType allFolders = msg.doReadFolders();
            List<FolderType> folders = allFolders.getFolder();
            this.getNodesFromXMLString(folders);
        }
        catch (AxisFault e) {
            this.log.error((Object)e.getMessage());
            System.setProperty("errorMessage", "Workplace cell is unavailable");
        }
        catch (I2B2Exception e) {
            this.log.error((Object)e.getMessage());
            System.setProperty("errorMessage", e.getMessage());
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            System.setProperty("errorMessage", "Remote server is unavailable");
        }
    }

    public Thread deleteNode(TreeViewer viewer) {
        final TreeNode theNode = this;
        final TreeViewer theViewer = viewer;
        final Display theDisplay = Display.getCurrent();
        return new Thread(){

            public void run() {
                try {
                    theNode.delete(theDisplay, theViewer);
                }
                catch (Exception e) {
                    System.setProperty("statusMessage", e.getMessage());
                }
                theDisplay.syncExec(new Runnable(){

                    public void run() {
                        theViewer.refresh(theNode.getParent());
                    }
                });
            }
        };
    }

    public void delete(Display theDisplay, final TreeViewer theViewer) {
        try {
            DeleteChildType childType = new DeleteChildType();
            childType.setNode("\\\\" + this.getData().getTableCd() + "\\" + this.getData().getIndex());
            DeleteChildResponseMessage msg = new DeleteChildResponseMessage();
            StatusType procStatus = null;
            while (procStatus == null || !procStatus.getType().equals("DONE")) {
                String response = WorkplaceServiceDriver.deleteChild(childType);
                procStatus = msg.processResult(response);
                if (!procStatus.getType().equals("ERROR")) continue;
                System.setProperty("errorMessage", procStatus.getValue());
                theDisplay.syncExec(new Runnable(){

                    public void run() {
                        MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                        mBox.setText("Please Note ...");
                        mBox.setMessage("Server reports: " + System.getProperty("errorMessage"));
                        mBox.open();
                    }
                });
                return;
            }
            ((TreeNode)this.getParent()).getChildren().remove(this);
        }
        catch (AxisFault e) {
            this.log.error((Object)e.getMessage());
            theDisplay.syncExec(new Runnable(){

                public void run() {
                    MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                    mBox.setText("Please Note ...");
                    mBox.setMessage("Unable to make a connection to the remote server\nThis is often a network error, please try again");
                    mBox.open();
                }
            });
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            theDisplay.syncExec(new Runnable(){

                public void run() {
                    MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                    mBox.setText("Please Note ...");
                    mBox.setMessage("Error message delivered from the remote server\nYou may wish to retry your last action");
                    mBox.open();
                }
            });
        }
    }

    public Thread moveNode(TreeViewer viewer) {
        final TreeNode theNode = this;
        final TreeViewer theViewer = viewer;
        final Display theDisplay = Display.getCurrent();
        return new Thread(){

            public void run() {
                try {
                    theNode.move(theDisplay, theViewer);
                    if (theNode.getData().getVisualAttributes().startsWith("F")) {
                        theNode.updateChildren(theDisplay, theViewer);
                    }
                }
                catch (Exception e) {
                    System.setProperty("statusMessage", e.getMessage());
                }
                theDisplay.syncExec(new Runnable(){

                    public void run() {
                        theViewer.refresh(theNode.getParent());
                        theViewer.refresh((Object)theNode);
                    }
                });
            }
        };
    }

    public void move(Display theDisplay, final TreeViewer theViewer) {
        try {
            ChildType childType = new ChildType();
            childType.setNode("\\\\" + this.getData().getTableCd() + "\\" + this.getData().getIndex());
            childType.setParent(this.getData().getParentIndex());
            MoveChildResponseMessage msg = new MoveChildResponseMessage();
            StatusType procStatus = null;
            while (procStatus == null || !procStatus.getType().equals("DONE")) {
                String response = WorkplaceServiceDriver.moveChild(childType);
                procStatus = msg.processResult(response);
                if (!procStatus.getType().equals("ERROR")) continue;
                System.setProperty("errorMessage", procStatus.getValue());
                theDisplay.syncExec(new Runnable(){

                    public void run() {
                        MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                        mBox.setText("Please Note ...");
                        mBox.setMessage("Server reports: " + System.getProperty("errorMessage"));
                        mBox.open();
                    }
                });
                return;
            }
        }
        catch (AxisFault e) {
            this.log.error((Object)e.getMessage());
            theDisplay.syncExec(new Runnable(){

                public void run() {
                    MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                    mBox.setText("Please Note ...");
                    mBox.setMessage("Unable to make a connection to the remote server\nThis is often a network error, please try again");
                    mBox.open();
                }
            });
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            theDisplay.syncExec(new Runnable(){

                public void run() {
                    MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                    mBox.setText("Please Note ...");
                    mBox.setMessage("Error message delivered from the remote server\nYou may wish to retry your last action");
                    mBox.open();
                }
            });
        }
    }

    public Thread renameNode(TreeViewer viewer) {
        final TreeNode theNode = this;
        final TreeViewer theViewer = viewer;
        final Display theDisplay = Display.getCurrent();
        String newName = null;
        InputDialog inputDialog = null;
        inputDialog = theNode.getData().getVisualAttributes().startsWith("F") ? new InputDialog(theDisplay.getActiveShell(), "Rename Folder Dialog", "Rename this folder to: ", theNode.getData().getName(), null) : new InputDialog(theDisplay.getActiveShell(), "Rename Work Item Dialog", "Rename this work item to: ", theNode.getData().getName(), null);
        if (inputDialog.open() == 0) {
            newName = inputDialog.getValue();
        }
        final String theNewName = newName;
        return new Thread(){

            public void run() {
                try {
                    if (theNewName != null) {
                        theNode.rename(theDisplay, theViewer, theNewName);
                    }
                }
                catch (Exception exception) {
                    TreeNode.this.log.error((Object)"Rename node error");
                }
                theDisplay.syncExec(new Runnable(){

                    public void run() {
                        theViewer.refresh((Object)theNode);
                    }
                });
            }
        };
    }

    public void rename(Display theDisplay, final TreeViewer theViewer, String theNewName) {
        XmlValueType newWorkXml = null;
        try {
            RenameChildResponseMessage msg = new RenameChildResponseMessage();
            StatusType procStatus = null;
            while (procStatus == null || !procStatus.getType().equals("DONE")) {
                RenameChildType childType = new RenameChildType();
                childType.setNode("\\\\" + this.getData().getTableCd() + "\\" + this.getData().getIndex());
                childType.setName(theNewName);
                newWorkXml = this.updateWorkXml(theNewName);
                childType.setWorkXml(newWorkXml);
                String response = WorkplaceServiceDriver.renameChild(childType);
                procStatus = msg.processResult(response);
                if (!procStatus.getType().equals("ERROR")) continue;
                System.setProperty("errorMessage", procStatus.getValue());
                theDisplay.syncExec(new Runnable(){

                    public void run() {
                        MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                        mBox.setText("Please Note ...");
                        mBox.setMessage("Server reports: " + System.getProperty("errorMessage"));
                        mBox.open();
                    }
                });
                return;
            }
            this.getData().setName(theNewName);
            if (newWorkXml != null) {
                this.getData().setWorkXml(newWorkXml);
            }
        }
        catch (AxisFault e) {
            this.log.error((Object)e.getMessage());
            theDisplay.syncExec(new Runnable(){

                public void run() {
                    MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                    mBox.setText("Please Note ...");
                    mBox.setMessage("Unable to make a connection to the remote server\nThis is often a network error, please try again");
                    mBox.open();
                }
            });
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            theDisplay.syncExec(new Runnable(){

                public void run() {
                    MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                    mBox.setText("Please Note ...");
                    mBox.setMessage("Error message delivered from the remote server\nYou may wish to retry your last action");
                    mBox.open();
                }
            });
        }
    }

    private XmlValueType updateWorkXml(String newName) {
        if (this.getData().getWorkXml() == null) {
            return null;
        }
        if (this.getData().getWorkXmlI2B2Type().equals("CONCEPT")) {
            Element rootElement = this.getData().getWorkXml().getAny().get(0);
            NodeList nameElements = rootElement.getElementsByTagName("name");
            nameElements.item(0).setTextContent(newName);
            NodeList synonymElements = rootElement.getElementsByTagName("synonym_cd");
            if (synonymElements.item(0) != null) {
                synonymElements.item(0).setTextContent("Y");
            }
        } else if (this.getData().getWorkXmlI2B2Type().equals("PATIENT_COLL")) {
            Element rootElement = this.getData().getWorkXml().getAny().get(0);
            NodeList descriptionElements = rootElement.getElementsByTagName("description");
            descriptionElements.item(0).setTextContent(newName);
        } else {
            Element rootElement = this.getData().getWorkXml().getAny().get(0);
            NodeList nameElements = rootElement.getElementsByTagName("name");
            if (nameElements.getLength() == 0) {
                nameElements = rootElement.getElementsByTagNameNS("*", "panel");
                if (nameElements.getLength() == 0) {
                    nameElements = rootElement.getElementsByTagName("query_name");
                    if (nameElements.getLength() == 0) {
                        return this.getData().getWorkXml();
                    }
                    nameElements.item(0).setTextContent(newName);
                } else {
                    nameElements.item(0).getAttributes().getNamedItem("name").setNodeValue(newName);
                }
            } else {
                nameElements.item(0).setTextContent(newName);
            }
        }
        return this.getData().getWorkXml();
    }

    public Thread annotateNode(TreeViewer viewer) {
        final TreeNode theNode = this;
        final TreeViewer theViewer = viewer;
        final Display theDisplay = Display.getCurrent();
        String newTooltip = null;
        InputDialog inputDialog = new InputDialog(theDisplay.getActiveShell(), "Annotate Work Item Dialog", "Annotate this work item: ", theNode.getData().getTooltip(), null);
        if (inputDialog.open() == 0) {
            newTooltip = inputDialog.getValue();
        }
        final String theNewTooltip = newTooltip;
        return new Thread(){

            public void run() {
                try {
                    if (theNewTooltip != null) {
                        theNode.annotate(theDisplay, theViewer, theNewTooltip);
                    }
                }
                catch (Exception exception) {
                    TreeNode.this.log.error((Object)"Annotate node error");
                }
                theDisplay.syncExec(new Runnable(){

                    public void run() {
                        theViewer.refresh((Object)theNode);
                    }
                });
            }
        };
    }

    public void annotate(Display theDisplay, final TreeViewer theViewer, String theNewTooltip) {
        try {
            AnnotateChildResponseMessage msg = new AnnotateChildResponseMessage();
            StatusType procStatus = null;
            while (procStatus == null || !procStatus.getType().equals("DONE")) {
                AnnotateChildType childType = new AnnotateChildType();
                childType.setNode("\\\\" + this.getData().getTableCd() + "\\" + this.getData().getIndex());
                childType.setTooltip(theNewTooltip);
                String response = WorkplaceServiceDriver.annotateChild(childType);
                procStatus = msg.processResult(response);
                if (!procStatus.getType().equals("ERROR")) continue;
                System.setProperty("errorMessage", procStatus.getValue());
                theDisplay.syncExec(new Runnable(){

                    public void run() {
                        MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                        mBox.setText("Please Note ...");
                        mBox.setMessage("Server reports: " + System.getProperty("errorMessage"));
                        mBox.open();
                    }
                });
                return;
            }
            this.getData().setTooltip(theNewTooltip);
        }
        catch (AxisFault e) {
            this.log.error((Object)e.getMessage());
            theDisplay.syncExec(new Runnable(){

                public void run() {
                    MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                    mBox.setText("Please Note ...");
                    mBox.setMessage("Unable to make a connection to the remote server\nThis is often a network error, please try again");
                    mBox.open();
                }
            });
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            theDisplay.syncExec(new Runnable(){

                public void run() {
                    MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                    mBox.setText("Please Note ...");
                    mBox.setMessage("Error message delivered from the remote server\nYou may wish to retry your last action");
                    mBox.open();
                }
            });
        }
    }

    public Thread addNode(TreeViewer viewer) {
        InputDialog inputDialog;
        final TreeNode theNode = this;
        final TreeViewer theViewer = viewer;
        final Display theDisplay = Display.getCurrent();
        if (theNode.getData().getName().equals("New Folder") && theNode.getData().getVisualAttributes().equals("FA") && (inputDialog = new InputDialog(theDisplay.getActiveShell(), "New Folder Dialog", "Name this folder: ", theNode.getData().getName(), null)).open() == 0) {
            String newName = inputDialog.getValue();
            this.getData().setName(newName);
            this.getData().setTooltip("FOLDER: " + newName);
        }
        return new Thread(){

            public void run() {
                try {
                    theNode.add(theDisplay, theViewer);
                }
                catch (Exception exception) {
                    TreeNode.this.log.error((Object)"Add node error");
                }
                theDisplay.syncExec(new Runnable(){

                    public void run() {
                        theViewer.refresh((Object)theNode);
                    }
                });
            }
        };
    }

    public void add(Display theDisplay, final TreeViewer theViewer) {
        try {
            WorkplaceResponseMessage msg = new WorkplaceResponseMessage();
            StatusType procStatus = null;
            while (procStatus == null || !procStatus.getType().equals("DONE")) {
                FolderType childType = new FolderType();
                childType.setName(this.getData().getName());
                childType.setGroupId(this.getData().getGroupId());
                childType.setIndex(this.getData().getIndex());
                childType.setParentIndex("\\\\" + this.getData().getTableCd() + "\\" + this.getData().getParentIndex());
                childType.setTooltip(this.getData().getTooltip());
                childType.setUserId(this.getData().getUserId());
                childType.setVisualAttributes(this.getData().getVisualAttributes());
                childType.setWorkXml(this.getData().getWorkXml());
                childType.setWorkXmlI2B2Type(this.getData().getWorkXmlI2B2Type());
                childType.setShareId(this.getData().getShareId());
                childType.setWorkXmlSchema(this.getData().getWorkXmlSchema());
                childType.setEntryDate(null);
                childType.setChangeDate(null);
                childType.setStatusCd(null);
                String response = WorkplaceServiceDriver.addChild(childType);
                procStatus = msg.processResult(response);
                if (!procStatus.getType().equals("ERROR")) continue;
                System.setProperty("errorMessage", procStatus.getValue());
                theDisplay.syncExec(new Runnable(){

                    public void run() {
                        MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                        mBox.setText("Please Note ...");
                        mBox.setMessage("Server reports: " + System.getProperty("errorMessage"));
                        mBox.open();
                    }
                });
                return;
            }
        }
        catch (AxisFault e) {
            this.log.error((Object)e.getMessage());
            theDisplay.syncExec(new Runnable(){

                public void run() {
                    MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                    mBox.setText("Please Note ...");
                    mBox.setMessage("Unable to make a connection to the remote server\nThis is often a network error, please try again");
                    mBox.open();
                }
            });
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            theDisplay.syncExec(new Runnable(){

                public void run() {
                    MessageBox mBox = new MessageBox(theViewer.getTree().getShell(), 34);
                    mBox.setText("Please Note ...");
                    mBox.setMessage("Error message delivered from the remote server\nYou may wish to retry your last action");
                    mBox.open();
                }
            });
        }
    }

    public void copyChildren(String indexShare) {
        String[] nodeInfo = indexShare.split(",");
        List children = this.getChildren();
        for (TreeNode childNode : children) {
            childNode.getData().setIndex(new AddChildRequestMessage().generateMessageId());
            childNode.getData().setParentIndex(nodeInfo[0]);
            childNode.getData().setShareId(nodeInfo[1]);
            childNode.addChild().start();
            if (childNode.getData().getVisualAttributes().startsWith("F")) {
                TreeNode placeholder;
                if (childNode.getData().getVisualAttributes().equals("FA")) {
                    placeholder = new TreeNode("working...", "working...", "LAO");
                    childNode.addChild(placeholder);
                } else if (childNode.getData().getVisualAttributes().equals("FH")) {
                    placeholder = new TreeNode("working...", "working...", "LHO");
                    childNode.addChild(placeholder);
                }
            }
            childNode.copyChildren(childNode.getData().getIndex());
        }
    }

    public Thread addChild() {
        final TreeNode theNode = this;
        return new Thread(){

            public void run() {
                try {
                    theNode.add();
                }
                catch (Exception exception) {
                    TreeNode.this.log.error((Object)"Copy children error");
                }
            }
        };
    }

    public void add() {
        try {
            WorkplaceResponseMessage msg = new WorkplaceResponseMessage();
            StatusType procStatus = null;
            while (procStatus == null || !procStatus.getType().equals("DONE")) {
                FolderType childType = new FolderType();
                childType.setName(this.getData().getName());
                childType.setGroupId(this.getData().getGroupId());
                childType.setIndex(this.getData().getIndex());
                childType.setParentIndex("\\\\" + this.getData().getTableCd() + "\\" + this.getData().getParentIndex());
                childType.setTooltip(this.getData().getTooltip());
                childType.setUserId(this.getData().getUserId());
                childType.setVisualAttributes(this.getData().getVisualAttributes());
                childType.setWorkXml(this.getData().getWorkXml());
                childType.setWorkXmlI2B2Type(this.getData().getWorkXmlI2B2Type());
                childType.setShareId(this.getData().getShareId());
                childType.setWorkXmlSchema(this.getData().getWorkXmlSchema());
                childType.setEntryDate(null);
                childType.setChangeDate(null);
                childType.setStatusCd(null);
                String response = WorkplaceServiceDriver.addChild(childType);
                procStatus = msg.processResult(response);
                if (!procStatus.getType().equals("ERROR")) continue;
                this.log.error((Object)procStatus.getValue());
                return;
            }
        }
        catch (AxisFault axisFault) {
            this.log.error((Object)"Unable to make a connection to the remote server\nThis is often a network error, please try again");
        }
        catch (Exception exception) {
            this.log.error((Object)"Error message delivered from the remote server\nYou may wish to retry your last action");
        }
    }
}

