/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.i2b2.eclipse.plugins.workplace.ws;

import edu.harvard.i2b2.common.util.jaxb.DTOFactory;
import edu.harvard.i2b2.common.util.jaxb.JAXBUtilException;
import edu.harvard.i2b2.eclipse.UserInfoBean;
import edu.harvard.i2b2.eclipse.plugins.workplace.util.Messages;
import edu.harvard.i2b2.eclipse.plugins.workplace.util.WorkplaceJAXBUtil;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.ApplicationType;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.BodyType;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.FacilityType;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.MessageControlIdType;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.MessageHeaderType;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.ObjectFactory;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.PasswordType;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.ProcessingIdType;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.RequestHeaderType;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.SecurityType;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WorkplaceRequestData {
    public static final String THIS_CLASS_NAME = WorkplaceRequestData.class.getName();
    private Log log = LogFactory.getLog((String)THIS_CLASS_NAME);

    public RequestHeaderType getRequestHeader() {
        RequestHeaderType reqHeader = new RequestHeaderType();
        reqHeader.setResultWaittimeMs(120000);
        return reqHeader;
    }

    protected MessageHeaderType getMessageHeader() {
        MessageHeaderType messageHeader = new MessageHeaderType();
        messageHeader.setI2B2VersionCompatible(new BigDecimal(Messages.getString("WorkplaceRequestData.i2b2VersionCompatible")));
        ApplicationType appType = new ApplicationType();
        appType.setApplicationName(Messages.getString("WorkplaceRequestData.SendingApplicationName"));
        appType.setApplicationVersion(Messages.getString("WorkplaceRequestData.SendingApplicationVersion"));
        messageHeader.setSendingApplication(appType);
        messageHeader.setAcceptAcknowledgementType(new String("messageId"));
        FacilityType facility = new FacilityType();
        facility.setFacilityName(Messages.getString("WorkplaceRequestData.SendingFacilityName"));
        messageHeader.setSendingFacility(facility);
        ApplicationType appType2 = new ApplicationType();
        appType2.setApplicationVersion(Messages.getString("WorkplaceRequestData.ReceivingApplicationVersion"));
        appType2.setApplicationName(Messages.getString("WorkplaceRequestData.ReceivingApplicationVersion"));
        messageHeader.setReceivingApplication(appType2);
        FacilityType facility2 = new FacilityType();
        facility2.setFacilityName(Messages.getString("WorkplaceRequestData.ReceivingFacilityName"));
        messageHeader.setReceivingFacility(facility2);
        Date currentDate = new Date();
        DTOFactory factory = new DTOFactory();
        messageHeader.setDatetimeOfMessage(factory.getXMLGregorianCalendar(currentDate.getTime()));
        SecurityType secType = new SecurityType();
        secType.setDomain(UserInfoBean.getInstance().getUserDomain());
        secType.setUsername(UserInfoBean.getInstance().getUserName());
        PasswordType ptype = new PasswordType();
        ptype.setIsToken(UserInfoBean.getInstance().getUserPasswordIsToken());
        ptype.setTokenMsTimeout(UserInfoBean.getInstance().getUserPasswordTimeout());
        ptype.setValue(UserInfoBean.getInstance().getUserPassword());
        secType.setPassword(ptype);
        messageHeader.setSecurity(secType);
        MessageControlIdType mcIdType = new MessageControlIdType();
        mcIdType.setInstanceNum(0);
        mcIdType.setMessageNum(this.generateMessageId());
        messageHeader.setMessageControlId(mcIdType);
        ProcessingIdType proc = new ProcessingIdType();
        proc.setProcessingId(Messages.getString("WorkplaceRequestData.ProcessingId"));
        proc.setProcessingMode(Messages.getString("WorkplaceRequestData.ProcessingMode"));
        messageHeader.setProcessingId(proc);
        messageHeader.setAcceptAcknowledgementType(Messages.getString("WorkplaceRequestData.AcceptAcknowledgementType"));
        messageHeader.setApplicationAcknowledgementType(Messages.getString("WorkplaceRequestData.ApplicationAcknowledgementType"));
        messageHeader.setCountryCode(Messages.getString("WorkplaceRequestData.CountryCode"));
        messageHeader.setProjectId(UserInfoBean.getInstance().getProjectId());
        return messageHeader;
    }

    public String generateMessageId() {
        StringWriter strWriter = new StringWriter();
        int i = 0;
        while (i < 20) {
            int num = this.getValidAcsiiValue();
            strWriter.append((char)num);
            ++i;
        }
        return strWriter.toString();
    }

    private int getValidAcsiiValue() {
        int number = 48;
        while (!((number = 48 + (int)Math.round(Math.random() * 74.0)) > 47 && number < 58 || number > 64 && number < 91 || number > 96 && number < 123)) {
        }
        return number;
    }

    public String getXMLString(RequestMessageType reqMessageType) throws JAXBUtilException {
        StringWriter strWriter = null;
        try {
            strWriter = new StringWriter();
            ObjectFactory of = new ObjectFactory();
            WorkplaceJAXBUtil.getJAXBUtil().marshaller(of.createRequest(reqMessageType), (Writer)strWriter);
        }
        catch (JAXBUtilException e) {
            this.log.error((Object)"Error marshalling Workplace request message");
            throw e;
        }
        return strWriter.toString();
    }

    public RequestMessageType getRequestMessageType(MessageHeaderType messageHeader, RequestHeaderType reqHeader, BodyType bodyType) {
        RequestMessageType reqMsgType = new RequestMessageType();
        reqMsgType.setMessageHeader(messageHeader);
        reqMsgType.setMessageBody(bodyType);
        reqMsgType.setRequestHeader(reqHeader);
        return reqMsgType;
    }
}

