/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.i2b2.eclipse.plugins.workplace.ws;

import edu.harvard.i2b2.common.util.jaxb.JAXBUnWrapHelper;
import edu.harvard.i2b2.common.util.jaxb.JAXBUtilException;
import edu.harvard.i2b2.eclipse.plugins.workplace.util.WorkplaceJAXBUtil;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.BodyType;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.ResponseHeaderType;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.wkplclient.datavo.i2b2message.StatusType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.FolderType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.FoldersType;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WorkplaceResponseData {
    public static final String THIS_CLASS_NAME = WorkplaceResponseData.class.getName();
    private Log log = LogFactory.getLog((String)THIS_CLASS_NAME);
    private ResponseMessageType respMessageType = null;

    public StatusType processResult(String response) {
        StatusType status = null;
        try {
            JAXBElement jaxbElement = WorkplaceJAXBUtil.getJAXBUtil().unMashallFromString(response);
            this.respMessageType = (ResponseMessageType)jaxbElement.getValue();
            ResponseHeaderType responseHeader = this.respMessageType.getResponseHeader();
            status = responseHeader.getResultStatus().getStatus();
            String procStatus = status.getType();
            String procMessage = status.getValue();
            if (procStatus.equals("ERROR")) {
                this.log.error((Object)("Error reported by Workplace web Service " + procMessage));
            } else if (procStatus.equals("WARNING")) {
                this.log.error((Object)("Warning reported by Workplace web Service" + procMessage));
            }
        }
        catch (JAXBUtilException e) {
            this.log.error((Object)e.getMessage());
        }
        return status;
    }

    public FoldersType doReadFolders() {
        FoldersType folders = null;
        try {
            BodyType bodyType = this.respMessageType.getMessageBody();
            JAXBUnWrapHelper helper = new JAXBUnWrapHelper();
            if (bodyType != null) {
                folders = (FoldersType)helper.getObjectByClass(bodyType.getAny(), FoldersType.class);
            }
        }
        catch (JAXBUtilException e) {
            this.log.error((Object)e.getMessage());
        }
        return folders;
    }

    public String getXMLString(FolderType folder) throws Exception {
        StringWriter strWriter = new StringWriter();
        try {
            WorkplaceJAXBUtil.getJAXBUtil().marshaller((Object)folder, (Writer)strWriter);
        }
        catch (JAXBUtilException e) {
            this.log.error((Object)"Error marshalling Workplace folder");
            throw new JAXBUtilException(e.getMessage(), (Exception)((Object)e));
        }
        return strWriter.toString();
    }
}

